<?php
/**
 * Displays footer site info
 *
 * @subpackage Child Care Kindergarten
 * @since 1.0
 * @version 1.4
 */

?>
<div class="site-info">
    <div class="row">
        <div class="col-lg-4 col-md-4 align-self-center">
            <?php if ( child_care_kindergarten_credit() ) : ?>
                 <p class="copyright-text my-3"><?php child_care_kindergarten_credit(); ?> <?php echo esc_html(get_theme_mod('child_care_kindergarten_footer_copy',__('By Luzuk','child-care-kindergarten'))); ?></p>
            <?php endif; ?>
        </div>
        <div class="col-lg-4 col-md-4 logo">
            <div class="inner-logo">
                <?php if ( has_custom_logo() ) : ?>
                    <?php the_custom_logo(); ?>
                <?php endif; ?>
                <?php if (get_theme_mod('child_care_kindergarten_show_site_title',true)) {?>
                    <?php $blog_info = get_bloginfo( 'name' ); ?>
                    <?php if ( ! empty( $blog_info ) ) : ?>
                        <?php if ( is_front_page() && is_home() ) : ?>
                            <h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
                        <?php else : ?>
                            <p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
                        <?php endif; ?>
                    <?php endif; ?>
                <?php }?>
                <?php if (get_theme_mod('child_care_kindergarten_show_tagline',true)) {?>
                    <?php
                        $description = get_bloginfo( 'description', 'display' );
                        if ( $description || is_customize_preview() ) :
                    ?>
                    <p class="site-description">
                        <?php echo esc_attr($description); ?>
                    </p>
                    <?php endif; ?>
                <?php }?>
            </div>
        </div>
        <div class="col-lg-4 col-md-4 align-self-center">
            <div class="social-icons text-lg-right text-center my-3">
                <?php if(get_theme_mod('child_care_kindergarten_topheader_twitter_url')) {?>
                    <a href="<?php echo esc_url(get_theme_mod('child_care_kindergarten_topheader_twitter_url')); ?>" class="mr-2"><i class="fab fa-twitter"></i><span class="screen-reader-text"><?php echo esc_html('Twitter', 'child-care-kindergarten'); ?></span></a>
                <?php }?>
                <?php if(get_theme_mod('child_care_kindergarten_topheader_facebook_url')) {?>
                    <a href="<?php echo esc_url(get_theme_mod('child_care_kindergarten_topheader_facebook_url')); ?>" class="mr-2"><i class="fab fa-facebook-f"></i><span class="screen-reader-text"><?php echo esc_html('Facebook', 'child-care-kindergarten'); ?></span></a>
                <?php }?>
                <?php if(get_theme_mod('child_care_kindergarten_topheader_instagram_url')) {?>
                    <a href="<?php echo esc_url(get_theme_mod('child_care_kindergarten_topheader_instagram_url')); ?>"><i class="fab fa-instagram"></i><span class="screen-reader-text"><?php echo esc_html('Instagram', 'child-care-kindergarten'); ?></span></a>
                <?php }?>
            </div>
        </div>
    </div>
</div>